/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.CanvasColorMap;
import cds.aladin.KernelList;
import cds.aladin.MyProperties;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.Tok;
import cds.allsky.Action;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderMoc;
import cds.allsky.BuilderRunner;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.allsky.ModeMerge;
import cds.allsky.ThreadBuilderTile;
import cds.fits.Fits;
import cds.moc.SMoc;
import cds.tools.pixtools.Util;
import java.awt.image.IndexColorModel;
import java.io.File;

public class BuilderRgb
extends BuilderRunner {
    private String[] inputs;
    private int[] cubeIndex;
    private SMoc[] moc;
    private MyProperties[] prop;
    private String[] labels;
    private String[] transfertFcts;
    private double[] pixelMin;
    private double[] pixelMax;
    private double[] pixelMiddle;
    private String output;
    private int width = -1;
    private double[] blank;
    private double[] bscale;
    private double[] bzero;
    private byte[][] tcm;
    private int[] bitpix;
    private int maxOrder = -1;
    private String frame = null;
    private int missing = -1;
    private boolean flagGauss;
    private boolean flagLupton;
    private double[] luptonS;
    private double[] luptonM;
    private double luptonQ;
    private int statNbFile;
    private ModeMerge coaddMode = ModeMerge.mergeOverwriteTile;
    private int format;
    static final double[] kernel = KernelList.createFastGaussienMatrix(2, 0.8);

    public BuilderRgb(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.RGB;
    }

    @Override
    public void run() throws Exception {
        Fits.setToolKit();
        this.build();
        this.context.resetCheckCode();
        this.context.setPropriete("hips_overlay", this.context.getModeOverlay().toString() + " " + this.context.getModeMerge().toString() + " " + this.context.getModeTree().toString());
        if (!this.context.isTaskAborting()) {
            new BuilderMoc(this.context).createMoc(this.output);
        }
        if (!this.context.isTaskAborting()) {
            new BuilderAllsky(this.context).run();
            this.context.done("ALLSKY file done");
        }
    }

    protected void activateCache(long size, long sizeCache) {
    }

    @Override
    public void showStatistics() {
        this.context.showRGBStat(this.statNbFile, this.totalTime, this.getNbThreads(), this.getNbThreadRunning());
    }

    @Override
    protected void setProgressBar(int npix) {
        this.context.setProgress(npix);
    }

    private void initStat() {
        this.context.setProgressMax(768.0);
        this.statNbFile = 0;
        this.startTime = System.currentTimeMillis();
    }

    private void updateStat() {
        ++this.statNbFile;
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }

    @Override
    protected int getBitpix0() {
        return 0;
    }

    @Override
    public void build() throws Exception {
        this.initStat();
        super.build();
    }

    private String removeCubeSuffixe(String path) {
        if (path == null) {
            return null;
        }
        if (!path.endsWith("]")) {
            return path;
        }
        int i = path.lastIndexOf(91);
        if (i <= 0) {
            return path;
        }
        try {
            Integer.parseInt(path.substring(i + 1, path.length() - 1));
            return path.substring(0, i);
        }
        catch (Exception exception) {
            return path;
        }
    }

    int getCubeIndex(String path) {
        if (path == null) {
            return 0;
        }
        if (!path.endsWith("]")) {
            return 0;
        }
        int i = path.lastIndexOf(91);
        if (i <= 0) {
            return 0;
        }
        try {
            return Integer.parseInt(path.substring(i + 1, path.length() - 1));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public void validateContext() throws Exception {
        int c;
        String path = this.context.getRgbOutput();
        this.format = this.context.getRgbFormat();
        this.coaddMode = this.context.getModeMerge();
        if (this.coaddMode != ModeMerge.mergeKeepTile && this.coaddMode != ModeMerge.mergeOverwriteTile) {
            if (this.context instanceof ContextGui) {
                this.context.setModeMerge(ModeMerge.mergeOverwriteTile);
            } else {
                throw new Exception("Only KEEPTILE and REPLACETILE modes are supported for RGB HiPS generation");
            }
        }
        String pathRef = null;
        this.inputs = new String[3];
        this.cubeIndex = new int[3];
        this.labels = new String[3];
        this.moc = new SMoc[3];
        this.prop = new MyProperties[3];
        this.pixelMin = new double[3];
        this.pixelMiddle = new double[3];
        this.pixelMax = new double[3];
        this.transfertFcts = new String[3];
        this.bitpix = new int[3];
        for (c = 0; c < 3; ++c) {
            this.bitpix[c] = 0;
        }
        this.blank = new double[3];
        this.bzero = new double[3];
        this.bscale = new double[3];
        this.tcm = new byte[3][];
        if (this.context.hasFrame()) {
            this.frame = this.context.getFrameName();
        }
        for (c = 0; c < 3; ++c) {
            this.inputs[c] = this.removeCubeSuffixe(this.context.plansRGB[c]);
            this.cubeIndex[c] = this.getCubeIndex(this.context.plansRGB[c]);
            if (this.inputs[c] == null) {
                if (this.missing != -1) {
                    throw new Exception("HiPS RGB generation required at least 2 original components");
                }
                this.missing = c;
                continue;
            }
            if (!this.context.isExistingAllskyDir(this.inputs[c])) {
                throw new Exception("Input HiPS missing [" + this.inputs[c] + "]");
            }
            if (pathRef == null) {
                pathRef = this.inputs[c];
            }
            this.prop[c] = this.loadProperties(this.inputs[c]);
            this.labels[c] = this.getLabelFromProp(this.prop[c], this.inputs[c]);
            String s = this.context.cmsRGB[c];
            if (s == null && (s = this.getCmParamFromProp(this.prop[c])) == null) {
                throw new Exception("Unknown pixelcut for " + this.labels[c]);
            }
            this.setCmParamExact(s, c);
            int o = this.getOrderFromProp(this.prop[c], this.inputs[c]);
            if (o > this.maxOrder) {
                this.maxOrder = o;
            }
            SMoc m = this.moc[c] = this.loadMoc(this.inputs[c]);
            this.context.moc = this.context.moc == null ? m : this.context.moc.union(m);
            String f = this.getFrameFromProp(this.prop[c]);
            if (this.frame == null) {
                this.frame = f;
                continue;
            }
            if (this.frame.equals(f)) continue;
            throw new Exception("Uncompatible coordsys for " + this.labels[c]);
        }
        if (path == null) {
            int n = pathRef.length() - 1;
            int offset = Math.max(pathRef.lastIndexOf(47, n), pathRef.lastIndexOf(92, n));
            path = pathRef.substring(0, offset + 1) + "RGBHiPS";
            this.context.warning("Missing \"out\" parameter. Assuming \"" + path + "\"");
        }
        this.output = path;
        if (this.context instanceof ContextGui) {
            this.context.resetProgressParam();
        }
        if (this.context.getOrder() == -1) {
            this.context.setOrder(this.maxOrder);
            this.context.info("Using order = " + this.maxOrder);
        } else {
            this.maxOrder = this.context.getOrder();
        }
        if (!this.context.hasFrame()) {
            this.context.setFrameName(this.frame);
            this.context.info("Using coordys = " + this.context.getFrameName());
        }
        this.context.setOutputPath(path);
        this.context.setBitpixOrig(0);
        if (this.context.flagLupton) {
            this.initLuptonParam();
        }
        for (c = 0; c < 3; ++c) {
            if (c == this.missing) continue;
            String info = this.flagLupton ? this.labels[c] + " [lupton min=" + this.R(this.luptonM[c]) + " scale=" + this.R(this.luptonS[c]) + " Q=" + this.luptonQ + "]" : this.labels[c] + " [" + this.pixelMin[c] + " " + this.pixelMiddle[c] + " " + this.pixelMax[c] + " " + this.transfertFcts[c] + "]";
            if (c == 0) {
                this.context.redInfo = info;
                continue;
            }
            if (c == 1) {
                this.context.greenInfo = info;
                continue;
            }
            this.context.blueInfo = info;
        }
        if (this.context.mocArea != null) {
            this.context.moc = this.context.moc.intersection(this.context.mocArea);
        }
        this.context.writeMetaFile();
    }

    public static double estimateLuptonS(PlanBG p) {
        return 10.0 / (p.getCutCtrlMax() - p.getCutCtrlMin());
    }

    public static double estimateLuptonM(PlanBG p) {
        return -(((p.getCutCtrlMin() + (p.getCutCtrlMax() - p.getCutCtrlMin()) / 20.0) * p.bScale + p.bZero) * BuilderRgb.estimateLuptonS(p));
    }

    private void initLuptonParam() {
        this.flagLupton = true;
        this.luptonQ = !Double.isNaN(this.context.luptonQ) ? this.context.luptonQ : 20.0;
        this.luptonS = new double[3];
        this.luptonM = new double[3];
        for (int c = 0; c < 3; ++c) {
            double z = 10.0 / (this.pixelMax[c] * this.bscale[c] + this.bzero[c] - (this.pixelMin[c] * this.bscale[c] + this.bzero[c]));
            this.luptonS[c] = !Double.isNaN(this.context.luptonS[c]) ? this.context.luptonS[c] : z;
            this.luptonM[c] = !Double.isNaN(this.context.luptonM[c]) ? this.context.luptonM[c] : -(((this.pixelMin[c] + (this.pixelMax[c] - this.pixelMin[c]) / 20.0) * this.bscale[c] + this.bzero[c]) * z);
        }
        String sm = this.luptonM[0] == this.luptonM[1] && this.luptonM[1] == this.luptonM[2] ? this.R(this.luptonM[0]) : this.R(this.luptonM[0]) + "/" + this.R(this.luptonM[1]) + "/" + this.R(this.luptonM[2]);
        String ss = this.luptonS[0] == this.luptonS[1] && this.luptonS[1] == this.luptonS[2] ? this.R(this.luptonS[0]) : this.R(this.luptonS[0]) + "/" + this.R(this.luptonS[1]) + "/" + this.R(this.luptonS[2]);
        this.context.info("Lupton algo: Q=" + this.luptonQ + " m=" + sm + " scale=" + ss);
    }

    private String R(double x) {
        return cds.tools.Util.myRound(x);
    }

    private SMoc loadMoc(String path) throws Exception {
        String s = path + Util.FS + "Moc.fits";
        if (!new File(s).canRead()) {
            return new SMoc("0/0-11");
        }
        SMoc m = new SMoc();
        m.read(s);
        return m;
    }

    private String getFrameFromProp(MyProperties prop) throws Exception {
        String s = prop.getProperty("hips_frame");
        if (s == null) {
            s = prop.getProperty("coordsys");
        }
        if (s == null) {
            s = "G";
        }
        return Context.getCanonicalFrameName(s);
    }

    private String getCmParamFromProp(MyProperties prop) throws Exception {
        String s = prop.getProperty("hips_pixel_cut");
        if (s == null) {
            s = prop.getProperty("pixelCut");
        }
        return s;
    }

    private String getLabelFromProp(MyProperties prop, String path) throws Exception {
        String s = null;
        if (prop != null) {
            s = prop.getProperty("obs_title");
            if (s == null) {
                prop.getProperty("obs_collection");
            }
            if (s == null) {
                prop.getProperty("label");
            }
        }
        if (s == null) {
            int offset = path.lastIndexOf(47);
            if (offset == -1) {
                offset = path.lastIndexOf(92);
            }
            s = path.substring(offset + 1);
        }
        return s;
    }

    private int getOrderFromProp(MyProperties prop, String path) throws Exception {
        int order = -1;
        String s = null;
        if (prop != null) {
            s = prop.getProperty("hips_order");
            if (s == null) {
                prop.getProperty("maxOrder");
            }
            try {
                order = Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (order == -1) {
            order = Util.getMaxOrderByPath(path);
        }
        return order;
    }

    private void setCmParamExact(String s, int c) throws Exception {
        int transfertFct;
        double max;
        double min;
        Tok tok = new Tok(s);
        try {
            min = Double.parseDouble(tok.nextToken());
            max = Double.parseDouble(tok.nextToken());
        }
        catch (Exception e1) {
            String s1 = this.getCmParamFromProp(this.prop[c]);
            Tok tok1 = new Tok(s1);
            try {
                min = Double.parseDouble(tok1.nextToken());
                max = Double.parseDouble(tok1.nextToken());
                tok = new Tok(s);
            }
            catch (Exception e2) {
                throw new Exception("Colormap parameter error [" + s + "] => usage: min [middle] max [fct]");
            }
        }
        if (max <= min) {
            throw new Exception("Colormap parameter error [" + s + "] => max<=min");
        }
        double med = Double.NaN;
        String fct = null;
        if (tok.hasMoreTokens()) {
            String s1 = tok.nextToken();
            try {
                double x = Double.parseDouble(s1);
                med = max;
                max = x;
            }
            catch (Exception e) {
                fct = s1;
            }
        }
        if (tok.hasMoreTokens()) {
            fct = tok.nextToken();
        }
        if (fct != null) {
            int i = cds.tools.Util.indexInArrayOf(fct, PlanImage.TRANSFERTFCT, true);
            if (i < 0) {
                throw new Exception("Colormap parameter error [" + s + "] => Unknown transfert function [" + fct + "]");
            }
            transfertFct = i;
        } else {
            transfertFct = 3;
        }
        this.transfertFcts[c] = PlanImage.getTransfertFctInfo(transfertFct);
        double bzero = 0.0;
        double bscale = 1.0;
        Fits f = new Fits();
        String name = Context.findOneNpixFile(this.inputs[c], "fits");
        if (name == null) {
            throw new Exception("Cannot determine BZERO and BSCALE for component " + c + " => no fits tile");
        }
        f.loadHeaderFITS(name);
        try {
            bzero = f.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bscale = f.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bscale[c] = bscale;
        this.bzero[c] = bzero;
        this.pixelMin[c] = (min - bzero) / bscale;
        this.pixelMiddle[c] = (med - bzero) / bscale;
        this.pixelMax[c] = (max - bzero) / bscale;
        int tr1 = 128;
        if (!Double.isNaN(med)) {
            if (med < min || med > max) {
                throw new Exception("Colormap parameter error [" + s + "] => med<min || med>max");
            }
            tr1 = (int)((med - min) / (max - min) * 255.0);
        }
        if (!this.context.flagLupton) {
            this.context.info("Using pixelCut " + this.L(c) + " = " + min + (Double.isNaN(med) ? "" : " " + med) + " " + max + (transfertFct != 3 ? " " + PlanImage.getTransfertFctInfo(transfertFct) : ""));
        }
        IndexColorModel cm = CanvasColorMap.getCM(0, tr1, 255, false, 0, transfertFct, true);
        this.tcm[c] = cds.tools.Util.getTableCM(cm, 2);
    }

    private String L(int c) {
        return c == 0 ? "red" : (c == 1 ? "green" : "blue");
    }

    @Override
    protected Fits createLeafHpx(ThreadBuilderTile hpx, String file, String path, int order, long npix, int z) throws Exception {
        Fits rgb;
        long t = System.currentTimeMillis();
        Fits[] in = this.getLeaves(order, npix);
        Fits fits = rgb = in == null ? null : this.createLeaveRGB(in);
        if (rgb == null) {
            long duree = System.currentTimeMillis() - t;
            this.updateStat(0, 0, 1, duree, 0, 0L);
            return null;
        }
        this.write(file, rgb);
        long duree = System.currentTimeMillis() - t;
        this.updateStat(0, 1, 0, duree, 0, 0L);
        this.updateStat();
        return rgb;
    }

    private Fits createLeaveRGB(Fits[] in) throws Exception {
        return this.flagLupton ? BuilderRgb.createLeaveRGBLupton(in, this.width, this.format, this.flagGauss, this.missing, this.luptonQ, this.luptonM, this.luptonS) : BuilderRgb.createLeaveRGBClassic(in, this.width, this.format, this.flagGauss, this.missing, this.pixelMin, this.pixelMax, this.tcm);
    }

    static double arcsinh(double v) {
        return Math.log(v + Math.sqrt(Math.pow(v, 2.0) + 1.0));
    }

    public static Fits createLeaveRGBLupton(Fits[] in, int width, int format, boolean flagGauss, int missing, double luptonQ, double[] luptonM, double[] luptonS) throws Exception {
        if (flagGauss) {
            for (int i = 0; i < 3; ++i) {
                BuilderRgb.gaussian(in[i]);
            }
        }
        double Q2 = Math.sqrt(luptonQ);
        double gap = 0.0;
        double range = 256.0;
        if (Fits.isTransparent(format == 0 ? 4 : 3)) {
            range = 255.0;
            gap = 1.0;
        }
        Fits rgb = new Fits(width, width, 0);
        double[] pix = new double[3];
        int i = 0;
        for (int y = 0; y < width; ++y) {
            int x = 0;
            while (x < width) {
                double I = 0.0;
                int tot = 0;
                boolean allBlank = true;
                for (int c = 0; c < 3; ++c) {
                    if (c == missing || in[c] == null) continue;
                    double v = in[c].getPixelFull(x, y);
                    if (in[c].isBlankPixel(v)) {
                        pix[c] = 0.0;
                    } else {
                        allBlank = false;
                        pix[c] = v * luptonS[c] + luptonM[c];
                        if (pix[c] < 0.0) {
                            pix[c] = 0.0;
                        }
                    }
                    I += pix[c];
                    ++tot;
                }
                if (allBlank) {
                    rgb.rgb[i] = 0;
                } else {
                    if ((I /= (double)tot) == 0.0) {
                        I = 1.0E-6;
                    }
                    double fI = BuilderRgb.arcsinh(luptonQ * I) / Q2;
                    if (missing != -1) {
                        pix[missing] = I;
                    }
                    int pixel = 255;
                    for (int c = 0; c < 3; ++c) {
                        double v = fI * pix[c] / I;
                        if (v > 0.999999) {
                            v = 0.999999;
                        }
                        v = (v = v * range + gap) < gap ? gap : (v > range ? range : v);
                        pixel = pixel << 8 | (int)v & 0xFF;
                    }
                    rgb.rgb[i] = pixel;
                }
                ++x;
                ++i;
            }
        }
        return rgb;
    }

    public static Fits createLeaveRGBClassic(Fits[] in, int width, int format, boolean flagGauss, int missing, double[] pixelMin, double[] pixelMax, byte[][] tcm) throws Exception {
        if (flagGauss) {
            for (int i = 0; i < 3; ++i) {
                BuilderRgb.gaussian(in[i]);
            }
        }
        double gap = 0.0;
        double range = 256.0;
        if (Fits.isTransparent(format == 0 ? 4 : 3)) {
            range = 255.0;
            gap = 1.0;
        }
        Fits rgb = new Fits(width, width, 0);
        double[] pix = new double[3];
        int i = 0;
        for (int y = 0; y < width; ++y) {
            int x = 0;
            while (x < width) {
                int pixel;
                double tot = 0.0;
                for (int c = 0; c < 3; ++c) {
                    if (c == missing || in[c] == null) continue;
                    double v = in[c].getPixelDouble(x, y);
                    if (in[c].isBlankPixel(v)) {
                        pix[c] = 0.0;
                        continue;
                    }
                    pix[c] = gap + (v < pixelMin[c] ? 0.0 : (v > pixelMax[c] ? range - gap - 1.0 : range * ((v - pixelMin[c]) / (pixelMax[c] - pixelMin[c]))));
                    tot += pix[c];
                }
                double[] pix8 = new double[3];
                if (tot == 0.0) {
                    pixel = 0;
                } else {
                    int c;
                    tot = 0.0;
                    for (c = 0; c < 3; ++c) {
                        if (c == missing) continue;
                        int itcm = (int)Math.floor(pix[c]);
                        if (tcm[c] == null) {
                            pix8[c] = itcm;
                        } else if (itcm >= 255) {
                            pix8[c] = tcm[c][255];
                        } else if ((double)itcm <= gap) {
                            pix8[c] = tcm[c][(int)gap];
                        } else {
                            double d1 = pix[c] - (double)itcm;
                            if (d1 == 0.0) {
                                pix8[c] = tcm[c][itcm] & 0xFF;
                            } else {
                                double d2 = 1.0 - d1;
                                double v1 = tcm[c][itcm] & 0xFF;
                                double v2 = tcm[c][itcm + 1] & 0xFF;
                                pix8[c] = (int)Math.round(v1 * d2 + v2 * d1);
                            }
                        }
                        tot += pix8[c];
                    }
                    if (missing != -1) {
                        pix8[missing] = tot / 2.0;
                    }
                    pixel = 255;
                    for (c = 0; c < 3; ++c) {
                        pixel = pixel << 8 | (int)pix8[c] & 0xFF;
                    }
                }
                rgb.rgb[i] = pixel;
                ++x;
                ++i;
            }
        }
        return rgb;
    }

    public static void gaussian(Fits in) {
        int x;
        int y;
        if (in == null) {
            return;
        }
        double[] inPixels = new double[in.width * in.height];
        int i = 0;
        for (y = 0; y < in.height; ++y) {
            for (x = 0; x < in.width; ++x) {
                inPixels[i++] = in.getPixelDouble(x, y);
            }
        }
        double[] outPixels = new double[inPixels.length];
        BuilderRgb.convolveAndTranspose(kernel, inPixels, outPixels, in.width, in.height);
        BuilderRgb.convolveAndTranspose(kernel, outPixels, inPixels, in.height, in.width);
        i = 0;
        for (y = 0; y < in.height; ++y) {
            for (x = 0; x < in.width; ++x) {
                in.setPixelDouble(x, y, inPixels[i++]);
            }
        }
    }

    private static void convolveAndTranspose(double[] k, double[] inPixels, double[] outPixels, int width, int height) {
        int cols = k.length;
        int cols2 = cols / 2;
        for (int y = 0; y < height; ++y) {
            int index = y;
            int ioffset = y * width;
            for (int x = 0; x < width; ++x) {
                double pixval = 0.0;
                for (int col = -cols2; col <= cols2; ++col) {
                    int ix = x + col;
                    if (ix < 0) {
                        ix = 0;
                    } else if (ix >= width) {
                        ix = width - 1;
                    }
                    pixval += inPixels[ioffset + ix] * k[col + cols2];
                }
                outPixels[index] = pixval;
                index += height;
            }
        }
    }

    private Fits[] getLeaves(int order, long npix) throws Exception {
        if (this.context.isTaskAborting()) {
            new Exception("Task abort !");
        }
        Fits[] out = null;
        out = new Fits[3];
        for (int c = 0; c < 3; ++c) {
            if (c == this.missing) continue;
            if (!this.moc[c].isIntersecting(order, npix)) {
                out[c] = null;
            } else {
                try {
                    out[c] = this.createSubLeaveRGB(order, npix, c);
                }
                catch (Exception e) {
                    out[c] = null;
                }
            }
            if (out[c] == null || this.bitpix[c] != 0) continue;
            this.bitpix[c] = out[c].bitpix;
            this.blank[c] = out[c].blank;
            this.bscale[c] = out[c].bscale;
            this.bzero[c] = out[c].bzero;
            if (this.width != -1) continue;
            this.width = out[c].width;
        }
        if (out[0] == null && out[1] == null && out[2] == null) {
            out = null;
        }
        return out;
    }

    private Fits createSubLeaveRGB(int order, long npix, int c) throws Exception {
        int srcPos;
        int x;
        int y;
        int o = order;
        String file = null;
        long n = npix;
        o = order;
        while (o >= 3 && !new File(file = Util.getFilePath(this.inputs[c], o, n, this.cubeIndex[c]) + ".fits").exists()) {
            --o;
            n /= 4L;
        }
        if (o < 3) {
            return null;
        }
        Fits fits = new Fits();
        fits.loadFITS(file);
        if (o == order) {
            return fits;
        }
        int xc = 0;
        int yc = fits.height - 1;
        int width = fits.width;
        for (int i = order; i > o; --i) {
            width /= 2;
        }
        int gap = 1;
        int w = width;
        int i = order;
        while (i > o) {
            gap *= 2;
            int child = (int)(npix % 4L);
            int offsetX = child == 2 || child == 3 ? w : 0;
            int offsetY = child == 1 || child == 3 ? w : 0;
            xc += offsetX;
            yc -= offsetY;
            --i;
            npix /= 4L;
            w *= 2;
        }
        int length = Math.abs(fits.bitpix) / 8;
        byte[] pixels = new byte[width * width * length];
        for (y = width - 1; y >= 0; --y) {
            for (x = 0; x < width; ++x) {
                srcPos = ((yc - (width - y - 1)) * fits.width + (xc + x)) * length;
                int destPos = (y * width + x) * length;
                System.arraycopy(fits.pixels, srcPos, pixels, destPos, length);
            }
        }
        for (y = width - 1; y >= 0; --y) {
            for (x = 0; x < width; ++x) {
                srcPos = (y * width + x) * length;
                for (int gapy = 0; gapy < gap; ++gapy) {
                    for (int gapx = 0; gapx < gap; ++gapx) {
                        int destPos = ((y * gap + gapy) * fits.width + (x * gap + gapx)) * length;
                        System.arraycopy(pixels, srcPos, fits.pixels, destPos, length);
                    }
                }
            }
        }
        return fits;
    }
}

